
/**
 ******************************************************************************
 *
 * @file        MG32_ADC_API.c
 * @brief       ADC API c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2021/05/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */




/* Includes ------------------------------------------------------------------*/
#include "MG32_ADC_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
static ADC_HandleTypeDef hADC;

/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       Initial H/W ADC 
 * @param[in]   None
 * @return		None
 *******************************************************************************
 */
void API_ADC_Init(void)
{
    ADC_AnalogWDGConfTypeDef ADC_WDG;

    /**Configure the global features of the ADC (Clock, Resolution, Data Alignment and number of conversion) 
    */
    hADC.Instance                   = ADC0;                     // for ADC0
    hADC.Init.ADCConType            = ADC_CONV_SINGLE;          // Single-end type
    hADC.Init.ADCClock              = ADC_CLOCKPROC_DIV4;       // ADC_Clock = ADC_PROC/4 
    hADC.Init.Resolution            = ADC_RESOLUTION_10B;       // ADC conversion resolution
    hADC.Init.DataAlign             = ADC_DATAALIGN_RIGHT;      // ADC data is Right-justified
    hADC.Init.ConversionMode        = ADC_ONESHOT;              // One-Shot control to converion 
    hADC.Init.LowPowerAutoWait      = ADC_CONTINUE_NEXT;        // ADC will replace the older conversion data (WAIT_EN for scan/loop mode)
    
    #if defined(MG32F02A132) | defined(MG32F02A072) | defined(MA862)
        hADC.Init.LowPowerAutoPowerOff = ADC_NORMAL_POWER;          // ADC keep in normal Power level
    #endif
    hADC.Init.TriggerConverionSrc   = ADC_SOFTWARE_START;       // ADC trigger event from software command
    hADC.Init.TriggerConverionEdge  = ADC_TRIGCONVEDGE_DUALEDGE;// ADC convert signal from external trigger event edge select
    hADC.Init.Overrun               = ADC_ACCEPT_OVERRUN;       // It will overrun the conversion data   
    hADC.Init.ExtendSamplingTime    = 0;                        // Extend time of 'Sample & Hold' of ADC conversion state (0 ADC_Clock)
    
    MID_ADC_Init(&hADC);
    
    // modify parameters (for ADC window detect)
    ADC_WDG.WatchdogMode    = ADC_ANALOGWATCHDOG_SINGLE_REG;
    ADC_WDG.Channel         = ADC_CHANNEL_0;
#if defined ( __GNUC__ )
    ADC_WDG.ITMode          = 0;                             	// polling mode
#else
    ADC_WDG.ITMode          = NULL;                             // polling mode
#endif
    ADC_WDG.HighThreshold   = 1023;                 
    ADC_WDG.LowThreshold    = 10; 
    ADC_WDG.WatchdogDataLimit = ADC_ANALOGWATCHDOG_CLAMP_THRESHOLD; // Clamp data when result is ouside
 
    MID_ADC_AnalogWDGConfig(&hADC, &ADC_WDG);

}

/**
 *******************************************************************************
 * @brief       ADC sample ADC_CHANNEL_0
 * @param[in]   None
 * @return		None
 *******************************************************************************
 */
uint16_t API_ADC_GetChannel0(void)
{
    ADC_ChannelConfTypeDef ADCChannelMux;
    
    ADCChannelMux.Channel = ADC_CHANNEL_0;
    
    /** Configure for the selected ADC regular channel to be converted.     **/
    MID_ADC_ConfigChannel(&hADC, &ADCChannelMux);
    
    // Trigger ADC Conversion
    MID_ADC_Start(&hADC);
    
    //  poll ADC flag
    MID_ADC_PollForConversion(&hADC, 10);
    
    // return ADC result
    return (uint16_t) MID_ADC_GetValue(&hADC);
}

